<?php require_once('Linode.php'); ?>
<?php
if (!empty($_POST['action'])) {

    $limit = 20;
    switch ($_POST['action']) {
        case 'create':

            $linode = new Linode($_POST['apikey'], $_POST['domain']);

            $servers = $linode->list_servers();
            $nbServers = is_array($servers['data']) && !empty($servers['data']) ? count($servers['data']) : 0;
            $limitLeft = $limit - $nbServers;

            if($limitLeft <= 0)
            {
                die(json_encode(['status' => FALSE, 'data' => 'you have reached maximum limit']));
            }

            $region = $linode->list_region();

            if(empty($region['data'])){

                die(json_encode(['status' => FALSE, 'data' => 'NO REGIONS FOUND']));
            }

            $region = $region['data'];
            $result = [];

            for($i = 0; $i < $limitLeft; $i++)
            {
                $data = $region[array_rand($region)];
                $location = $data['id'];
                $sub = 'linode'.rand(0, 1000);
                $result[] = $linode->create_server($sub, $location, $_POST['type']);
            }
            die(json_encode(['status' => TRUE, 'data' => $result ]));
        break;

        case 'get':
            $linode = new Linode($_POST['apikey'], '');
            $servers = $linode->list_servers();
            if (!array_key_exists("errors",$servers))
            {
                if($servers['results'] > 0)
                {
                   die(json_encode(['status' => TRUE, 'data' => $servers['data'] ]));
                }
            }
           
            die(json_encode(['status' => FALSE, 'data' => 'NO SERVERS FOUND OR WRONG API']));
            
        break;

        case 'delete':
        	$linode = new Linode($_POST['apikey'], '');
        	$result = $linode->delete($_POST['id']);
        	die(json_encode(['status' => TRUE, 'data' => $result ]));
        break;

        case 'bulk_delete':
            if(!is_array($_POST['ids']))
            {
              die(json_encode(['status' => FALSE, 'data' => 'Select at Least one server']));
            }
            $linode = new Linode($_POST['apikey'], '');
            foreach ($_POST['ids'] as $value) {
              $result [] = $linode->delete($value);
            }
            die(json_encode(['status' => TRUE, 'data' => $result ]));
        break;

         case 'test':
        	include_once('Net/SFTP.php');
        	 $ssh = new Net_SFTP($_POST['ip']);
        	 if (!$ssh->login('root', 'shell.2018')) {
                $result  = 'COULDNT CONNECT USING USER ROOT AND PASS shell.2018'.$value;
              } else {
                
               
                $cmd = 'echo "Test" | mail -v -s "Important - '.$_POST['ip'].'" '.$_POST['email'];
                $ssh->exec("yum install -y -d1 mailx sendmail sendmail-cf;"); //yum install -y mailx
                $ssh->exec("make -C /etc/mail;");
                $ssh->exec("service sendmail restart;");
                $ssh->exec($cmd);
                $result = 'EMAIL SENDED '.$value;
                
              }
              die(json_encode(['status' => TRUE, 'data' => $result ]));
        break;

        case 'bulk_test':
            if(!is_array($_POST['ips']))
            {
              die(json_encode(['status' => FALSE, 'data' => 'Select at Least one server']));
            }
            include_once('Net/SFTP.php');


            foreach ($_POST['ips'] as $value) {

              $ssh = new Net_SFTP($value);
              if (!$ssh->login('root', 'shell.2018')) {
                $result [] = 'COULDNT CONNECT USING USER ROOT AND PASS shell.2018'.$value;
              } else {
                
                $cmd = 'echo "Test" | mail -v -s "Important - '.$value.'" '.$_POST['email'];
                $ssh->exec("yum install -y -d1 mailx sendmail sendmail-cf;"); //yum install -y mailx
                $ssh->exec("make -C /etc/mail;");
                $ssh->exec("service sendmail restart;");
                $ssh->exec($cmd);
                $result [] = 'EMAIL SENDED '.$value;
              }
              unset($ssh);
            }
            die(json_encode(['status' => TRUE, 'data' => $result ]));
         break;
    }

    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>PROVIDERS</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="./favicon.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.2.1/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css"
          href="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/b-html5-1.5.6/r-2.2.2/datatables.min.css"/>
          <link rel="stylesheet" href="https://cdn.datatables.net/select/1.3.0/css/select.dataTables.min.css">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.6/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.2.1/js/bootstrap.min.js"></script>
    <script type="text/javascript"
            src="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/b-html5-1.5.6/r-2.2.2/datatables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8.8.7/dist/sweetalert2.all.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/select/1.3.0/js/dataTables.select.min.js"></script>
    <style>
        /* Show it is fixed to the top */
        body {
            min-height: 75rem;
            padding-top: 4.5rem;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-md navbar-dark fixed-top bg-dark">
    <a class="navbar-brand" href="#">PROVIDERS</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse"
            aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarCollapse">
        <ul class="navbar-nav mr-auto">
            <li class="nav-item">
                <a class="nav-link" href="./index.php">Digital Ocean</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="./scale.php">Scaleway</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="./cloud.php">Cloudcone</a>
            </li>
            <li class="nav-item active">
                <a class="nav-link" href="./lin.php">Linode</a>
            </li>
        </ul>

    </div>
</nav>

<div class="container-fluid" style="margin-top: 30px">
    <div class="row">
        <div class="col-sm-12 col-md-6 offset-md-3">
            <h4>LINODE</h4>
            <div class="form-group">
                <label for="#apikey">API KEY :</label>
                <input type="text" id="apikey" class="form-control"/>
            </div>
            <div class="form-group">
                <label for="#domain">Domain :</label>
                <input type="text" id="domain" class="form-control"/>
            </div>
            <div class="form-group">
                <label for="type">Type :</label>
                <select class="form-control" id="type"><option value="g6-nanode-1">Nanode 1GB</option><option value="g6-standard-1">Linode 2GB</option><option value="g6-standard-2">Linode 4GB</option><option value="g6-standard-4">Linode 8GB</option><option value="g6-standard-6">Linode 16GB</option><option value="g6-standard-8">Linode 32GB</option><option value="g6-standard-16">Linode 64GB</option><option value="g6-standard-20">Linode 96GB</option><option value="g6-standard-24">Linode 128GB</option><option value="g6-standard-32">Linode 192GB</option><option value="g6-highmem-1">Linode 24GB</option><option value="g6-highmem-2">Linode 48GB</option><option value="g6-highmem-4">Linode 90GB</option><option value="g6-highmem-8">Linode 150GB</option><option value="g6-highmem-16">Linode 300GB</option><option value="g6-dedicated-2">Dedicated 4GB</option><option value="g6-dedicated-8">Dedicated 16GB</option><option value="g6-dedicated-16">Dedicated 32GB</option><option value="g6-dedicated-32">Dedicated 64GB</option><option value="g6-dedicated-48">Dedicated 96GB</option></select>
            </div>         
            <div class="form-group">
                <button id="create" class="btn btn-primary">CREATE</button>
                <button id="get" class="btn btn-secondary">GET</button>
            </div>
        </div>
    </div>
    <div class="row" id="result">
        <div class="col-sm-12">
            <h4>Total Servers <span id="total">0</span></h4>
            <div class="table-responsive">
                <table id="Table1" class="table table-sm table-hover table-striped" style="width:100%">

                </table>
            </div>
        </div>
    </div>
</div>
<script>
    const spinner = "<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\"></span>";
    $('#result').hide();
    $("#create").click(function (e) {
        e.preventDefault();

        if(!confirm("Are You Sure ?"))
        {
          return;
        }

        let api = $("#apikey").val();
        let domain = $("#domain").val() || 'domain.com';
        let nb = $("#nbservers").val() || 10;

        if (api && domain && nb) {
            let btn = this;
            $(btn).attr('disabled', true);
            $(btn).html("CREATING " + spinner);

            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    action: 'create',
                    apikey: api,
                    domain: domain,
                    type : $('#type').val(),
                }
            }).done(function (e) {
                if (e.status) {
                    Swal.fire({
                        type: 'success',
                        title: 'Done',
                        text: 'Servers Created'
                    })
                } else {
                    Swal.fire({
                        type: 'error',
                        title: 'Oops',
                        text: e.data
                    })
                }
            }).always(function () {
                $(btn).attr('disabled', false);
                $(btn).html("CREATE");
            });
        } else {
            Swal.fire({
                type: 'error',
                title: 'Oops',
                text: 'Fill all data'

            });
        }
    });

    //get droplets
    $("#get").click(function (e) {
        e.preventDefault();
        let api = $("#apikey").val();
        if (api) {

            if ($.fn.DataTable.isDataTable("#Table1")) {
                $("#Table1").DataTable().destroy();
                $("#Table1").html("");
                $("#result").hide(1000);
            }

            let btn = this;
            $(btn).attr('disabled', true);
            $(btn).html("GETTING " + spinner);


            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    action: 'get',
                    apikey: api
                }
            }).done(function (e) {
                if (e.status) {
                    $("#result").show(1000);
                    $("#total").html(e.data.length);
                    $buttons = [
                        {
                            text: 'Select all',
                            action: function(e, dt, node, config){
                                dt.rows().select();
                            },
                            className: "btn-sm btn-primary",
                        },
                        {
                            text: 'Select none',
                            action:  function(e, dt, node, config){
                                dt.rows().deselect();
                            },
                            className: "btn-sm btn-danger",
                        },
                        {
                            extend: "csv",
                            text: "export to csv",
                            header: false,
                            fieldBoundary: "",
                            fieldSeparator: ",",
                            filename: `Servers_${(new Date().getTime()).toString(16)}`,
                            extension: ".txt",
                            exportOptions: {
                                columns: [2],
                                format: {

                                    body: function (data, row, column, node) {
                                        return `${data},shell.2018`;
                                    }
                                }
                            },
                            className: "btn-sm btn-info",
                        },
                        {
                          text : "Delete",
                          className : "btn-sm btn-danger",
                          action : function(e, dt, node, config){
                             const count = dt.rows( { selected: true } ).count();
                             if(count > 0)
                             {
                               const data = dt.rows({selected:true}).data();
                               $(node).attr("disabled", true);
                               $(node).html("Deleting "+spinner);
                               const ids = $.map(data, function(i){
                                 return i["id"];
                               });
                               console.log(ids);
                               $.ajax({
                                 type : "post",
                                 dataType : "json",
                                 data : {
                                   action : "bulk_delete",
                                   ids : ids,
                                   apikey :$("#apikey").val()
                                 }
                               }).done(function(res){
                                 Swal.fire({
                                   type : res.status ? "success" : "error",
                                   title : res.status ? "Done" : "Oops",
                                   html : res.status ? "Servers Deleted" : ":("
                                 }).then((result) => {
                                   if(res.status){
                                     dt.rows({selected : true}).remove().draw();
                                     $("#total").html(dt.rows().count());
                                  }
                                 });

                               }).always(function(res){
                                 $(node).attr("disabled", false);
                                 $(node).html("Delete");
                               });

                             }
                             else {
                               Swal.fire({
                                   type: 'warning',
                                   title: 'Uh oh!',
                                   text: 'Select at least one server'
                               });
                             }

                          }
                        },
                        {
                          text : "Test Email",
                          className : "btn-sm btn-success",
                          action : function(e, dt, node, config){
                            const count = dt.rows( { selected: true } ).count();
                            if(count > 0)
                            {
                              const email = prompt("Enter Your Email");
                              if(!email)
                              {
                                Swal.fire({
                                    type: 'warning',
                                    title: 'Uh oh!',
                                    text: 'Your must enter an email'
                                });

                                return;
                              }
                              const data = dt.rows({selected:true}).data();
                              $(node).attr("disabled", true);
                              $(node).html("Sending ... "+spinner);
                              const ips = $.map(data, function(i){
                                return i["ipv4"][0];
                              });
                              console.log(ips);
                              $.ajax({
                                type : "post",
                                dataType : "json",
                                data : {
                                  action : "bulk_test",
                                  ips : ips,
                                  email : email
                                }
                              }).done(function(res){
                                let result = "";
                                if(res.status){
                                  $.each(res.data, function(i,v){
                                    result += v +"<br>";
                                  });
                                }
                                Swal.fire({
                                  type : res.status ? "success" : "error",
                                  title : res.status ? "Done" : "Oops",
                                  html : res.status ? result : ":("
                                });

                              }).always(function(res){
                                $(node).attr("disabled", false);
                                $(node).html("Test Email");
                              });

                            }
                            else {
                              Swal.fire({
                                  type: 'warning',
                                  title: 'Uh oh!',
                                  text: 'Select at least one server'
                              });
                            }
                          }
                        }
                    ];
                    $columns = [
                        { title: "ID", data: "id", className: "text-center" },
                        { title: "hostname", data: "label", className: "text-center" },
                        { title: "main ip", data: "ipv4[0]",  className: "text-center" },
                        { title: "Status", data: "status",  className: "text-center" },
                        { title: "Created At", data: "created",  className: "text-center" },
                        { title: "Region", data: "region",  className: "text-center" },

                        {title : "Actions", render : function(data,type,row) {
                        	var emailtest = `<button class="btn btn-sm btn-success" type="button" data-ip="${row["ipv4"][0]}" onclick="actions(this,'test');">TEST EMAIL</button>&nbsp;`
                            var btndelete = `<button class="btn btn-sm btn-danger" type="button" data-id="${row["id"]}" onclick="actions(this,'delete');">DELETE</button>&nbsp;`;                         
                            
                            return emailtest + btndelete ;  

                            }, className: "text-center", orderable : false 
                        }
                       
                    ];

                    if (e.data.length > 0) {
                        $("#Table1").DataTable({
                            dom: "<'row'<'col-sm-5'B><'col-sm-2'><'col-sm-5'f>>" +
                                "<'row'<'col-sm-12'tr>>" +
                                "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                            buttons: $buttons,
                            scrollCollapse: true,
                            Destroy: true,
                            //responsive: true,
                            paging: false,
                            order: [[0, "asc"]],
                            processing: true,
                            select :{
                              style : "multi"
                            },
                            data: e.data,
                            columns: $columns
                        });
                    } else {
                        Swal.fire({
                            type: 'info',
                            title: 'Done',
                            text: 'No Instances Found'
                        });
                    }
                } else {
                    Swal.fire({
                        type: 'error',
                        title: 'Oops',
                        text: e.data
                    })
                }
            }).always(function () {
                $(btn).attr('disabled', false);
                $(btn).html("GET");
            });


        } else {
            Swal.fire({
                type: 'error',
                title: 'Oops',
                text: 'API KEY IS REQUIRED'

            });
        }
    });

    function actions(event, action){


        let api = $("#apikey").val();
        if(!api){
            Swal.fire({
                type: 'error',
                title: 'Oops',
                text: 'API KEY IS REQUIRED'

            });
            return;
        }
        switch(action){
            case 'delete' :
                if(confirm("ARE YOU SURE ?")){
                    $(event).attr("disabled", true);
                    $(event).html("DELETING "+spinner);

                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        data: {
                            action: 'delete',
                            apikey: api,
                            id : $(event).data("id")
                        }
                    }).done(function (e) {
                        if(e.data.code == 200)
                        {
                            $(event).closest ("tr").remove();
                            $("#total").text(parseInt($("#total").text())-1 || 0 ) ;
                            Swal.fire({
                                type : "success",
                                title : "Done",
                                text : "Server Deleted"
                            });
                        } else {
                            Swal.fire({
                                type : "error",
                                title : "Oops",
                                text : "Something happen"
                            });
                        }
                    });
                }
                break;

            case 'test' :
                let email = prompt("Enter Your Email");
                console.log(email);
                if(email){
                    $(event).attr("disabled", true);
                    $(event).html("TESTING "+spinner);

                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        data: {
                            action: 'test',
                            ip: $(event).data("ip"),
                            email : email
                        }
                    }).done(function (e) {

                        Swal.fire({
                            type : e.status ? "success" : "error",
                            title : e.status ? "Done" : "Oops...",
                            text : e.data
                        });

                    }).always(function () {
                        $(event).attr("disabled", false);//////.
                        $(event).html("EMAIL TEST");
                    });
                }
                break;
            default :
                alert("unknow action");
        }
    }

    $(window).bind("resize", function () {
        $($.fn.dataTable.tables(true)).DataTable().columns.adjust().responsive.recalc();
    });
</script>
</body>
</html>
