<?php

class digital
{
    protected $apiurl = 'https://api.digitalocean.com';
    protected $apikey;
    protected $defaultDomain;
    protected $data_header;

    public function __construct($apikey, $domain = '')
    {
        ini_set('max_execution_time', 0);
        $this->defaultDomain =  $domain;
        $this->apikey = $apikey;
        $this->data_header = array (
            "Content-Type: application/json",
            "Authorization: Bearer {$apikey}"
        );
    }

    private function callAPI($url, $headerdata, $data = NULL, $method = 'GET')
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //curl_setopt($ch, CURLOPT_HEADER, 1);
        if($method == 'POST' && $data != NULL)
        {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        elseif($method == 'PUT' && !$data)
        {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        else
        {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerdata);

        $json = json_decode(curl_exec($ch), true);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $json['code'] = $httpCode;

        if (curl_errno($ch)) {
            die(json_encode(array("status" => FALSE, "response" => curl_error($ch) )));
        }
        curl_close ($ch);

        return $json;
    }

    public function account_info()
    {
        $link = $this->apiurl."/v2/account";
        return $this->callAPI($link, $this->data_header);
    }

    public function account_actions($id = 0)
    {
        if($id != 0)
        {
            $link = $this->apiurl."/v2/actions/{$id}";
        }
        else
        {
            $link = $this->apiurl."/v2/actions";
        }
        return $this->callAPI($link, $this->data_header);
    }

    public function get_droplets($region = '')
    {
        $link = $this->apiurl."/v2/droplets?per_page=200&page=1";
        if(!empty($region))
        {
            $link .= '&region='.$region;
        }
        return $this->callAPI($link, $this->data_header);
    }

    public function create_droplet($subdomain, $region, $sshkey, $size = 's-1vcpu-1gb', $image = 34902021, $ipv6 = false)
    {
        $link = $this->apiurl."/v2/droplets";

        $data = array(
            'name' => $subdomain.'.'.$this->defaultDomain,
            'region' => $region,
            'size' => $size,
            'image' => $image,
            'ipv6' => $ipv6,
            'ssh_keys' => $sshkey

        );

        return $this->callAPI($link, $this->data_header, $data, 'POST');
    }

    public function delete_droplet($idServer)
    {
        $link = $this->apiurl."/v2/droplets/{$idServer}";
        return $this->callAPI($link, $this->data_header, NULL, 'DELETE');

    }

    public function action_droplet($idServer, $action = 'reboot', $newname = 'test.com')
    {
        //action option
        //shutdown
        //power_off
        //password_reset
        //power_cycle
        //rename
        //rebuild
        //enable_ipv6

        $link = $this->apiurl."/v2/droplets/{$idServer}/actions";

        $data = array(
            'type' => $action
        );
        if($action == 'rebuild')
            $data['image'] = 34902021; //?

        if($action == 'rename')
            $data['name'] = $newname;

        return $this->callAPI($link, $this->data_header, $data, 'POST');
    }

    public function get_sizes()
    {
        $link = $this->apiurl."/v2/sizes";
        return $this->callAPI($link, $this->data_header);
    }

    public function get_regions()
    {
        $link = $this->apiurl."/v2/regions";
        $region = $this->callAPI($link, $this->data_header);
        if(isset($region['regions']))
        {
            foreach ($region['regions'] as  $reg)
            {
                if($reg['available'])
                {
                    $result[] = $reg['slug'];
                }
            }
            return array('result' => $result, 'status' => TRUE);
        }
        else
        {
            return array('result' => $region, 'status' => FALSE);
        }

    }

    public function get_images($image = '')
    {

        $link = $this->apiurl."/v2/images";
        if(!empty($image))
            $link .= "/{$image}";
        return $this->callAPI($link, $this->data_header);
    }

    public function get_keys($key = NULL)
    {
        $link = $this->apiurl."/v2/account/keys";
        if(!$key)
            $link .= "/${key}";
        return $this->callAPI($link, $this->data_header);
    }

}