<?php

class cloudcone
{
	protected $apiurl_compute   = 'https://api.cloudcone.com/api/v1/compute';
	protected $data_header;
	protected $defaultDomain;

	public function __construct($apikey, $apihash, $domain = 'domain.com')
	{
    $this->defaultDomain = $domain;
    $this->data_header = array (
      "App-Secret: {$apikey}",
      "Hash: {$apihash}"
    );
	}

	private function callAPI($url, $headerdata, $data = FALSE, $method = 'GET')
	{
	    $ch = curl_init();

	    curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		if($method == 'POST' && !empty($data) && is_array($data))
		{
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
		}
		else
		{
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		}

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headerdata);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    die(json_encode(array("status" => FALSE, "response" => curl_error($ch) )));
		}
		curl_close ($ch);
		return json_decode($result, TRUE);
	}

	public function boot($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/boot";
		return $this->callAPI($link, $this->data_header);
	}

	public function create($subdomain, $cpu = 1, $ram = 1000, $disk = 20, $ips =1, $os = 18, $ssd = 1, $ptvnet = 0,  $ipv6 = 'on')
	{
		$this->data_header[] = "Content-Type: application/x-www-form-urlencoded";
		$data_vm = array (
			'hostname' => $subdomain.'.'.$this->defaultDomain,
			'cpu' => $cpu,
			'ram' => $ram,
			'disk' => $disk,
			'ips' => $ips,
			'os' => $os,
			'ssd' => $ssd,
			'pvtnet' => $ptvnet,
			'ipv6' => $ipv6
		);

		$link = $this->apiurl_compute.'/create';
		return $this->callAPI($link, $this->data_header, $data_vm, 'POST');
	}

	public function destroy($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/destroy";
		return $this->callAPI($link, $this->data_header);
	}

	public function graphs($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/info";
		return $this->callAPI($link, $this->data_header);
	}

	public function list_instances()
	{
		$link = $this->apiurl_compute."/list/instances";
		return $this->callAPI($link, $this->data_header, NULL);
	}

	public function list_os()
	{
		$link = $this->apiurl_compute."/list/os";
		return $this->callAPI($link, $this->data_header, NULL);
	}


	public function reboot($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/reboot";
		return $this->callAPI($link, $this->data_header);
	}

	public function reinstall($idServer, $os = 18) //18
	{
		$this->data_header[] = "Content-Type: application/x-www-form-urlencoded";
		$link = $this->apiurl_compute."/{$idServer}/reinstall";
		$data = array('os' => $os);
		return $this->callAPI($link, $this->data_header, $data, 'POST');
	}

	public function reset_password($idServer, $newpassword = '', $reboot = 'true')
	{
		$this->data_header[] = "Content-Type: application/x-www-form-urlencoded";
		$link = $this->apiurl_compute."/{$idServer}/reset/pass";
		$data = array('password' => $newpassword, 'reboot' => $reboot);
		return $this->callAPI($link, $this->data_header, $data, 'POST');
	}

	public function resize($idServer, $cpu = 1, $ram = 1024, $disk = 20)
	{
		$this->data_header[] = "Content-Type: application/x-www-form-urlencoded";
		$link = $this->apiurl_compute."/{$idServer}/resize";
		$data = array('cpu' => $cpu, 'ram' => $ram, 'disk' => $disk);
		return $this->callAPI($link, $this->data_header, $data, 'POST');
	}

	public function shutdown($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/shutdown";
		return $this->callAPI($link, $this->data_header);
	}

	public function status($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/status";
		return $this->callAPI($link, $this->data_header);
	}

	public function vnc($idServer)
	{
		$link = $this->apiurl_compute."/{$idServer}/vnc";
		return $this->callAPI($link, $this->data_header);
	}

}

/* End of file cloudcone.php */
/* Location: ./application/libraries/cloudcone.php */
