<?php
class Linode
{
	protected $ci;
	protected $apiurl = 'https://api.linode.com/v4';
	protected $apikey;
	protected $defaultDomain = 'domain.com';
	protected $data_header;

	public function __construct($apikey, $domain)
	{
  		$this->defaultDomain = isset($domain) ? $domain : $this->defaultDomain;
    	$this->apikey = $apikey;
    	$this->data_header = array (
        	"Authorization: Bearer ".$this->apikey 
		);
		ini_set('max_execution_time', 0);
	}


	private function callAPI($url, $headerdata, $data = NULL, $method = 'GET', $proxytouse = false)
	{
		
		//$proxy = $proxytouse ? explode(":", $proxytouse) : $this->get_proxy($try);

		//if(empty($proxy)){
		//	 return (json_encode(array("errormsg" => 'INVALID PROXYS AFTER 5 TRIES')));
		//}
		
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch,CURLOPT_CONNECTTIMEOUT, 5);

		if($method == 'POST' && $data != NULL)
		{
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
		}
		elseif($method == 'DELETE')
		{
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		}
		
		
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headerdata);

		$json = json_decode(curl_exec($ch), true);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		if (curl_errno($ch)) {
		    die(json_encode(array("status" => FALSE, "response" => curl_error($ch) )));
		}
		curl_close ($ch);

		return array_merge(['code' => $httpCode], $json);
	}

	public function list_region()
	{
		$link = $this->apiurl."/regions";
		return $this->callAPI($link, $this->data_header);
	}

	public function list_servers()
	{
		//
		$link = $this->apiurl."/linode/instances";
		return $this->callAPI($link, $this->data_header);
	}

	public function get_sshkey()
	{
		$link = $this->apiurl."/profile/sshkeys";
		return $this->callAPI($link, $this->data_header);
	}

	public function type_severs()
	{
		$link = $this->apiurl."/linode/types";
		return $this->callAPI($link, $this->data_header);
	}

	public function images()
	{
		$link = $this->apiurl."/images";
		return $this->callAPI($link, $this->data_header);
	}

	public function create_server($sub, $region, $type = 'g6-standard-1', $proxy = false)
	{
		$this->data_header[] = "Content-Type: application/json";
		$link = $this->apiurl."/linode/instances";
		$data = array(
			'type' => $type,
			'image' => 'linode/centos6.8',
			'backups_enabled' => false,
			'region' => $region,
			'root_pass' => 'shell.2018',
			//'authorized_keys' => [(string)$sshkey],
			'label' => $sub.'.'.$this->defaultDomain,
			
		);
		return $this->callAPI($link, $this->data_header, $data, 'POST', $proxy);
	}

	public function delete($id, $proxy = false)
	{
		$this->data_header[] = "Content-Type: application/json";
		$link = $this->apiurl."/linode/instances/{$id}";
		return $this->callAPI($link, $this->data_header, null, 'DELETE', $proxy);
	}

	

}

/* End of file Linode.php */
/* Location: .//C/Users/med amine/AppData/Local/Temp/BvSshSftp/Bv000972/Bv000972/Linode.php */
